uniform sampler2D 	posTex,
					normalTex;
uniform vec3		sundir;
varying vec2 		texcoord;

#ifdef ALPHABLEND

	uniform sampler2D 	bgTex,
						colorTex;

#endif

uniform float 	a0, 	// Br
		a1,	// Bm
		c1,	// Br+Bm
		c2,	// 3/16PI
		c3,	// 1/4PI
		c4,	// (1-g)^2
		c5,	// 1+g^2
		c6,	// 2g
		c7,	// 3/2
		SUN,	// E sun
		e;	// e

uniform vec4	L0;
				

void main()
{
	vec3 normal = texture2D(normalTex,texcoord.st).xyz;
	float s = texture2D(posTex,texcoord.st).z;
	normalize(normal);

	float Fex=pow(e,-C1*s);

	float cos=dot(sundir,normal);

	float Br=C2*A0*(1-(cos*cos));

	Bm=C3*A1*(C4/pow((C5-C6*cos),C7));

	float Lin=((Br+Bm)/c1)*SUN*(1-Fex);

#ifdef ALPHABLEND

	vec4 dest=texture2D(bgTex,texcoord.st);
	vec4 color=texture2D(colorTex,texcoord.st);
	vec4 finalcolor;
	finalcolor.xyz = (dest.xyz*(1.0-color.a)) + ((L0*Fex + Lin)*color.a);
	gl_FragColor=finalcolor;
	
#else

	gl_FragColor=L0*Fex + Lin;
	
#endif
	
}
